<?php
require_once '../../config.php';
include '../includes/auth.php';

// Get all branches with their product counts
$branches = $conn->query("
    SELECT b.*, COUNT(bp.product_id) as product_count 
    FROM branches b 
    LEFT JOIN branch_products bp ON b.id = bp.branch_id 
    GROUP BY b.id 
    ORDER BY b.name
");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Product Mappings</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background-color: #f8f9fa; }
        .card { border-radius: 1rem; box-shadow: 0 0.5rem 1rem rgba(0,0,0,.05); }
        .btn { border-radius: .5rem; }
    </style>
</head>
<body>
    <?php include '../includes/header.php'; ?>

    <div class="container py-5">
        <div class="card">
            <div class="card-header bg-info text-white">
                <h4 class="mb-0">📦 Product Mappings</h4>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped table-hover align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>SAP Code</th>
                                <th>Branch Name</th>
                                <th>Email</th>
                                <th>Contact Person</th>
                                <th>Mapped Products</th>
                                <th class="text-center">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while ($branch = $branches->fetch_assoc()): ?>
                            <tr>
                                <td><?= htmlspecialchars($branch['code']) ?></td>
                                <td><?= htmlspecialchars($branch['name']) ?></td>
                                <td><?= htmlspecialchars($branch['email']) ?></td>
                                <td><?= htmlspecialchars($branch['contact_person']) ?></td>
                                <td><span class="badge bg-secondary"><?= $branch['product_count'] ?></span></td>
                                <td class="text-center">
                                    <a href="edit.php?branch_id=<?= $branch['id'] ?>" class="btn btn-sm btn-warning">
                                        ✏️ Edit Mappings
                                    </a>
                                </td>
                            </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <?php include '../includes/footer.php'; ?>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
