<?php
// At the top of process_order.php
require_once '../../config.php';
include '../includes/auth.php';
//require_once '../includes/sap_client.php';
require_once 'sap_functions.php';

function processOrder($orderId) {
    global $conn;
    
    $conn->begin_Transaction();
    
    try {
        // Update order status
        $stmt = $conn->prepare("UPDATE orders SET status = 'processed' WHERE id = ?");
        $stmt->bind_param("i", $orderId);
        $stmt->execute();
        
        // Get order details
        $stmt = $conn->prepare("
            SELECT o.id AS portal_id, b.code AS branch_code, 1300 AS plant,
            1000 AS sales_org, 'ZISR' AS order_type, o.delivery_Date as date
            FROM orders o
            JOIN branches b ON o.branch_id = b.id
            WHERE o.id = ?
        ");
        $stmt->bind_param("i", $orderId);
        $stmt->execute();
        $order = $stmt->get_result();
//        $stmt->execute([$orderId]);
//        $order = $orderResult->fetch_array(MYSQLI_NUM);

        
        // Get order items
        $stmt = $conn->prepare("
            SELECT p.code AS material, oi.quantity AS target_qty, 1399 AS store_loc
            FROM order_items oi
            JOIN products p ON oi.product_id = p.id 
            WHERE order_id = ?
        ");
        $stmt->bind_param("i", $orderId);
        $stmt->execute();
        $items = $stmt->get_result();
//        $stmt->execute([$orderId]);
//        $itemResult = $stmt->get_result();
//        $items = $itemResult->fetch_assoc();
        
        // Prepare data for SAP
        $sapOrderData = [
//            'portal_id' => $order['id'], // Your portal ID
//            'branch_code' => $order['branch_code'],
//            'plant' => '1300',
//            'sales_org' => '1000',
//            'order_type' => 'ZSIR', // Standard order
//            'date' => date('Y-m-d'),
            'order' => $order,
            'items' => $items
        ];
        
        // Generate SOAP XML
        $soapXML = generateSAPSoapXML($sapOrderData);
        
        // Send to SAP
        $result = sendToSAP($soapXML);
        
        // Update SAP sync status
        $syncStatus = $result['success'] ? 'sent' : 'failed';
        $stmt = $conn->prepare("UPDATE orders SET sap_sync_status = ? WHERE id = ?");
        $stmt->execute([$syncStatus, $orderId]);
        
        // Log transaction
        $stmt = $conn->prepare("
            INSERT INTO sap_logs 
            (order_id, status, request_xml, response_xml, created_at)
            VALUES (?, ?, ?, ?, NOW())
        ");
        $stmt->execute([
            $orderId,
            $result['success'] ? 'success' : 'failed',
            $soapXML,
            $result['response']
        ]);
        
        $conn->commit();
        return $result;
        
    } catch (Exception $e) {
        $conn->rollBack();
        error_log("Order Processing Error: " . $e->getMessage());
        return ['success' => false, 'error' => $e->getMessage()];
    }
}

function sendToSAP($soapXML) {
    $endpoint = 'https://dawnwdp.dawnbread.net:8006/sap/bc/srt/rfc/sap/zta_sap_kfc_so_integration_s/900/zta_sap_kfc_so_integration_s/zta_sap_kfc_so_integration_s';
    $username = 'mit_web';
    $password = 'Dawn@12345';
     
    $ch = curl_init($endpoint);
    
    curl_setopt_array($ch, [
        CURLOPT_POST => true,
        CURLOPT_HTTPHEADER => [
            'Content-Type: text/xml; charset=utf-8',
            'SOAPAction: urn:sap-com:document:sap:rfc:functions:ZTA_SAP_KFC_SO_INTEGRATION',
            'Authorization: Basic ' . base64_encode("$username:$password")
        ],
        CURLOPT_POSTFIELDS => $soapXML,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_SSL_VERIFYPEER => true,
        CURLOPT_TIMEOUT => 30
    ]);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    curl_close($ch);
    
    if ($error) {
        return [
            'success' => false,
            'error' => 'cURL Error: ' . $error,
            'response' => $response
        ];
    }
    
    if ($httpCode >= 400) {
        return [
            'success' => false,
            'error' => "HTTP Error: $httpCode",
            'response' => $response
        ];
    }
    
    
    // Parse SOAP response
    try {
        $xml = simplexml_load_string($response);
        
        // Register namespaces
        $soapenv = $xml->getNamespaces(true)['soapenv'];
        $urn = $xml->getNamespaces(true)['urn'];
        
        // Check for SOAP fault
        $fault = $xml->children($soapenv)->Body->children($soapenv)->Fault;
        if (isset($fault) && count($fault) > 0) {
            $faultString = (string)$fault->faultstring;
            return [
                'success' => false,
                'error' => 'SAP Error: ' . $faultString,
                'response' => $response
            ];
        }
        
        // Extract SAP response - Updated method
        $sapResponse = $xml->children($soapenv)->Body->children($urn)->{'ZTA_SAP_KFC_SO_INTEGRATION.Response'};
        
        return [
            'success' => true,
            'sap_order_id' => (string)$sapResponse->VBELN, // Sales order number
            'message' => (string)$sapResponse->MESSAGE,
            'type' => (string)$sapResponse->TYPE,
            'response' => $response
        ];
        
    } catch (Exception $e) {
        return [
            'success' => false,
            'error' => 'XML Parse Error: ' . $e->getMessage(),
            'response' => $response
        ];
    }
}



// Handle AJAX request
if (isset($_POST['order_id']) ) {
    ob_start();
    $result = processOrder($_POST['order_id']);
    ob_end_clean();
    
    // Return XML response
    header('Content-Type: application/xml');
    $xml = new SimpleXMLElement('<Response/>');
    $xml->addChild('Success', $result['success'] ? 'true' : 'false');
    
    if ($result['success']) {
        $xml->addChild('SAPOrderID', $result['sap_order_id']);
        $xml->addChild('Message', $result['message']);
    } else {
        $xml->addChild('Error', $result['error']);
    }
    
    echo $xml->asXML();
    exit;
}
?>