<?php
require_once '../config.php';
include 'includes/auth.php';
include_once '../includes/nav_helper.php';

$branch_id = $_SESSION['branch_id'];

// Get products assigned to this branch
$stmt = $conn->prepare("
    SELECT p.* FROM products p
    JOIN branch_products bp ON p.id = bp.product_id
    WHERE bp.branch_id = ? AND p.status = 'active'
");
$stmt->bind_param("i", $branch_id);
$stmt->execute();
$products = $stmt->get_result();

// Current date for delivery
$current_date = date('Y-m-d');
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Available Products</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<?php include 'includes/header.php'; ?>

<div class="container py-5">
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white">
            <h4 class="mb-0">Available Products</h4>
        </div>
        <div class="card-body">
            <form method="post" action="place_order.php">
                <div class="table-responsive">
                    <table class="table table-striped table-bordered align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>Product Code</th>
                                <th>Product</th>
                                <!-- <th width="120">Price</th> -->
                                <th width="120">Quantity</th>
                                <th width="60">Select</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while ($product = $products->fetch_assoc()): ?>
                            <tr>
                            
                                <td><?= htmlspecialchars($product['code']) ?></td>
                                <td><?= htmlspecialchars($product['name']) ?></td>
                                <!-- <td>$<?= number_format($product['price'], 2) ?></td> -->
                                <td>
                                    <input type="number" class="form-control" 
                                           name="quantities[<?= $product['id'] ?>]" value="1" min="1">
                                </td>
                                <td class="text-center">
                                    <input type="checkbox" class="form-check-input" 
                                           name="products[]" value="<?= $product['id'] ?>">
                                </td>    
                            </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>

                <div class="row mb-3">
                    <div class="col-md-4">
                        <label for="delivery_date" class="form-label">Delivery Date:</label>
                        <input type="date" class="form-control" 
                               name="delivery_date" id="delivery_date" 
                               value="<?= $current_date ?>" required>
                    </div>
                </div>

                <div class="d-flex gap-3">
                    <button type="submit" class="btn btn-success">🛒 Place Order</button>
                    <a href="dashboard.php" class="btn btn-secondary">⬅ Back to Dashboard</a>
                </div>
            </form>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
</body>
</html>
