<?php
require_once '../../config.php';
include '../includes/auth.php';

if (!isset($_GET['id'])) {
    header("Location: index.php");
    exit();
}

$company_id = $_GET['id'];

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $name = $_POST['name'];
    $email = $_POST['email'];
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
    $address = $_POST['address'];
    $code = $_POST['code'];
    $plant = $_POST['plant'];
    $st_location = $_POST['st_location'];
    $auart = $_POST['auart'];

    // Check if email already exists (excluding current branch)
    $stmt = $conn->prepare("SELECT id FROM company WHERE email = ? AND id != ?");
    $stmt->bind_param("si", $email, $company_id);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result->num_rows > 0) {
        $error = "Email already exists. Please use a different email.";
    }

    // Check if company code already exists (excluding current company)
    if (!isset($error) && !empty($code)) {
        $stmt = $conn->prepare("SELECT id FROM company WHERE code = ? AND id != ?");
        $stmt->bind_param("si", $code, $company_id);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($result->num_rows > 0) {
            $error = "Company Code already exists. Please use a different code.";
        }
    }

    if (!isset($error)) {
        // Update password only if provided
        if (!empty($_POST['password'])) {
            $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
            $stmt = $conn->prepare("UPDATE company SET name=?, email=?, password=?, address=?, code=?, plant=?, st_location=?, auart=? WHERE id=?");
            $stmt->bind_param("ssssssssi", $name, $email, $password, $address, $code, $plant, $st_location, $auart, $company_id);
        } else {
            $stmt = $conn->prepare("UPDATE company SET name=?, email=?, address=?, code=?, plant=?, st_location=?, auart=? WHERE id=?");
            $stmt->bind_param("sssssssi", $name, $email, $address, $code, $plant, $st_location, $auart, $company_id);
        }

        if ($stmt->execute()) {
            header("Location: index.php?success=1");
            exit();
        } else {
            $error = "Error updating Company";
        }
    }
} else {
    $stmt = $conn->prepare("SELECT * FROM company WHERE id=?");
    $stmt->bind_param("i", $company_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 1) {
        $company = $result->fetch_assoc();
    } else {
        header("Location: index.php");
        exit();
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Edit Company</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background-color: #f8f9fa; }
        .card { border-radius: 1rem; box-shadow: 0 0.5rem 1rem rgba(0,0,0,.05); }
        .btn { border-radius: .5rem; }
    </style>
</head>
<body>
<?php include '../includes/header.php'; ?>

<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <div class="card">
                <div class="card-body">
                    <h1 class="h4 mb-4">✏️ Edit Company</h1>

                    <?php if (isset($error)): ?>
                        <div class="alert alert-danger"><?= $error ?></div>
                    <?php endif; ?>

                    <form method="post">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label">Name:</label>
                                <input type="text" name="name" value="<?= htmlspecialchars($company['name']) ?>" class="form-control" required>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Email:</label>
                                <input type="email" name="email" value="<?= htmlspecialchars($company['email']) ?>" class="form-control" required>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Password (leave blank to keep current):</label>
                                <input type="password" name="password" class="form-control">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Company Code:</label>
                                <input type="text" name="code" value="<?= htmlspecialchars($company['code']) ?>" class="form-control">
                                <div class="form-text">Company Code must be unique</div>
                            </div>
                             <div class="col-md-6">
                                <label class="form-label">Delivery Plant:</label>
                                <input type="text" name="plant" value="<?= htmlspecialchars($company['plant']) ?>" class="form-control">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Storage Location:</label>
                                <input type="text" name="st_location" value="<?= htmlspecialchars($company['st_location']) ?>" class="form-control">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">order Type:</label>
                                <input type="text" name="auart" value="<?= htmlspecialchars($company['auart']) ?>" class="form-control">
                                <div class="form-text">value from ZISR, ZISA, ZISD</div>
                            </div>
                            <div class="col-md-12">
                                <label class="form-label">Address:</label>
                                <textarea name="address" class="form-control" rows="2"><?= htmlspecialchars($company['address']) ?></textarea>
                            </div>
                        </div>

                        <div class="d-flex justify-content-between mt-4">
                            <button type="submit" class="btn btn-primary">💾 Update Company</button>
                            <a href="index.php" class="btn btn-secondary">↩ Cancel</a>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
