<?php
require_once '../../config.php';
include '../includes/auth.php';

if (!isset($_GET['id'])) {
    header("Location: index.php");
    exit();
}

$customer_id = $_GET['id'];

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $name = $_POST['name'];
    $email = $_POST['email'];
    $address = $_POST['address'];
    $contact_person = $_POST['contact_person'];
    $phone = $_POST['phone'];
    $code = $_POST['code'];
    $status = $_POST['status'];

    // Check if email already exists (excluding current branch)
    $stmt = $conn->prepare("SELECT id FROM customers WHERE email = ? AND id != ?");
    $stmt->bind_param("si", $email, $customer_id);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result->num_rows > 0) {
        $error = "Email already exists. Please use a different email.";
    }

    // Check if customer code already exists (excluding current customer)
    if (!isset($error) && !empty($code)) {
        $stmt = $conn->prepare("SELECT id FROM customers WHERE code = ? AND id != ?");
        $stmt->bind_param("si", $code, $customer_id);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($result->num_rows > 0) {
            $error = "Customer Code already exists. Please use a different code.";
        }
    }

    if (!isset($error)) {
        // Update password only if provided
        if (!empty($_POST['password'])) {
            $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
            $stmt = $conn->prepare("UPDATE customers SET name=?, email=?, password=?, address=?, contact_person=?, phone=?, code=?, status=? WHERE id=?");
            $stmt->bind_param("ssssssssi", $name, $email, $password, $address, $contact_person, $phone, $code, $status, $customer_id);
        } else {
            $stmt = $conn->prepare("UPDATE customers SET name=?, email=?, address=?, contact_person=?, phone=?, code=?, status=? WHERE id=?");
            $stmt->bind_param("sssssssi", $name, $email, $address, $contact_person, $phone, $code, $status, $customer_id);
        }

        if ($stmt->execute()) {
            header("Location: index.php?success=1");
            exit();
        } else {
            $error = "Error updating customer";
        }
    }
} else {
    $stmt = $conn->prepare("SELECT * FROM customers WHERE id=?");
    $stmt->bind_param("i", $customer_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 1) {
        $customer = $result->fetch_assoc();
    } else {
        header("Location: index.php");
        exit();
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Edit Customer</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background-color: #f8f9fa; }
        .card { border-radius: 1rem; box-shadow: 0 0.5rem 1rem rgba(0,0,0,.05); }
        .btn { border-radius: .5rem; }
    </style>
</head>
<body>
<?php include '../includes/header.php'; ?>

<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <div class="card">
                <div class="card-body">
                    <h1 class="h4 mb-4">✏️ Edit Customer</h1>

                    <?php if (isset($error)): ?>
                        <div class="alert alert-danger"><?= $error ?></div>
                    <?php endif; ?>

                    <form method="post">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label">Name:</label>
                                <input type="text" name="name" value="<?= htmlspecialchars($customer['name']) ?>" class="form-control" required>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Email:</label>
                                <input type="email" name="email" value="<?= htmlspecialchars($customer['email']) ?>" class="form-control" required>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Password (leave blank to keep current):</label>
                                <input type="password" name="password" class="form-control">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Contact Person:</label>
                                <input type="text" name="contact_person" value="<?= htmlspecialchars($customer['contact_person']) ?>" class="form-control">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Phone:</label>
                                <input type="text" name="phone" value="<?= htmlspecialchars($customer['phone']) ?>" class="form-control">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Customer Code:</label>
                                <input type="text" name="code" value="<?= htmlspecialchars($customer['code']) ?>" class="form-control">
                                <div class="form-text">Customer Code must be unique</div>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Status:</label>
                                <select name="status" class="form-select">
                                    <option value="active" <?= $customer['status'] == 'active' ? 'selected' : '' ?>>Active</option>
                                    <option value="inactive" <?= $customer['status'] == 'inactive' ? 'selected' : '' ?>>Inactive</option>
                                </select>
                            </div>
                            <div class="col-md-12">
                                <label class="form-label">Address:</label>
                                <textarea name="address" class="form-control" rows="2"><?= htmlspecialchars($customer['address']) ?></textarea>
                            </div>
                        </div>

                        <div class="d-flex justify-content-between mt-4">
                            <button type="submit" class="btn btn-primary">💾 Update Customer</button>
                            <a href="index.php" class="btn btn-secondary">↩ Cancel</a>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
