<?php
class SAPClient {
    private $client;
    private $wsdl;
    private $credentials;


    public function __construct($wsdl, $username, $password) {
        $this->wsdl = 'https://dawnwdp.dawnbread.net:8006/sap/bc/srt/wsdl/flv_10002A101AD1/srvc_url/sap/bc/srt/rfc/sap/zta_sap_snd_so_integration_s/900/zta_sap_snd_so_integration_s/zta_sap_snd_so_integration_s?sap-client=900';  //$wsdl
        $this->credentials = [
            'login' =>  'mit_web',     //$username
            'password' => 'Dawn@12345',    //$password
            'trace' => true,
            'exceptions' => true,
	    'compression' => SOAP_COMPRESSION_ACCEPT | SOAP_COMPRESSION_GZIP,
	    'encoding' => 'utf-8'
        ];
        
        try {
            $this->client = new SoapClient($this->wsdl, $this->credentials);
        } catch (SoapFault $e) {
//            throw new Exception("SAP Connection Error: " . $e->getMessage());
            print_r ($e->getMessage());

        }
    }
    public function createOrder($orderData) {
        try {
            $xml = $this->buildOrderXML($orderData);
            $params = [
                'OrderXML' => $xml
            ];
            print_r ($xml);
            $response = $this->client->CreateSalesOrder($params);
            // Validate response
            if (!isset($response->SalesOrderID)) {
                throw new Exception("Invalid SAP response: Missing SalesOrderID");
            }
           
            return [
                'success' => true,
                'sap_order_id' => $response->SalesOrderID,
                'response' => $response
            ];

        } catch (SoapFault $e) {
            // Log detailed error for debugging
            error_log("SAP SOAP Fault: " . $e->getMessage());
            error_log("Request: " . $this->client->__getLastRequest());
            error_log("Response: " . $this->client->__getLastResponse());

            return [
                'success' => false,
                'error' => "SAP Error: " . $e->getMessage(),
                'response' => $e
            ];
        } catch (Exception $e) {
            return [
                'success' => false,
                'error' => $e->getMessage(),
                'response' => null
            ];
        }
    }

    private function buildOrderXML($orderData) {
        $xml = new SimpleXMLElement('<SalesOrder/>');
        $xml->addChild('BranchCode', $orderData['branch_code']);
        $xml->addChild('OrderNumber', $orderData['order_number']);
        
        $items = $xml->addChild('Items');
        foreach ($orderData['items'] as $item) {
            $itemNode = $items->addChild('Item');
            $itemNode->addChild('MaterialNumber', $item['material_number']);
            $itemNode->addChild('Quantity', $item['quantity']);
            $itemNode->addChild('Price', $item['price']);
        }
        
        return $xml->asXML();
    }
}
?>