<?php
require_once '../../config.php';
include '../includes/auth.php';
// Get all products
$products = $conn->query("SELECT * FROM products ORDER BY name");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Manage Products</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Add Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <style>
        body { 
            background-color: #f8f9fa; 
        }
        .card { 
            border-radius: 1rem; 
            box-shadow: 0 0.5rem 1rem rgba(0,0,0,.05); 
        }
        .btn { 
            border-radius: .5rem; 
        }
        table { 
            margin-top: 20px; 
        }
        /* Smaller table font size */
        .table {
            font-size: 0.85rem;
        }
        /* Icon button styling */
        .icon-btn {
            padding: 0.25rem 0.5rem;
            margin: 0 0.1rem;
        }
        /* Sortable header styles */
        .sortable {
            cursor: pointer;
            position: relative;
            padding-right: 25px !important;
        }
        .sortable:hover {
            background-color: rgba(255,255,255,0.1);
        }
        .sort-icon {
            position: absolute;
            right: 8px;
            top: 50%;
            transform: translateY(-50%);
            opacity: 0.5;
        }
        .sorted-asc .sort-icon:before {
            content: "\F233"; /* Bootstrap icon for arrow-up-short */
        }
        .sorted-desc .sort-icon:before {
            content: "\F236"; /* Bootstrap icon for arrow-down-short */
        }
        .sorted-asc .sort-icon, 
        .sorted-desc .sort-icon {
            opacity: 1;
        }
    </style>
</head>
<body>
    <?php include '../includes/header.php'; ?>
    <div class="container py-5">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h1 class="h4">📦 Manage Products</h1>
            <a href="add.php" class="btn btn-primary">
                <i class="bi bi-plus-circle"></i> Add New Product
            </a>
        </div>
        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped table-hover align-middle" id="productsTable">
                        <thead class="table-dark">
                            <tr>
                                <th>ID</th>
                                <th class="sortable" data-column="1">
                                    Product Code
                                    <i class="bi sort-icon"></i>
                                </th>
                                <th class="sortable" data-column="2">
                                    Name
                                    <i class="bi sort-icon"></i>
                                </th>
                                <!-- <th>Description</th> -->
                                <!-- <th>Price</th> -->
                                <th>Status</th>
                                <th>Mapped Branches</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while ($product = $products->fetch_assoc()): 
                                // Get count of branches this product is mapped to
                                $stmt = $conn->prepare("SELECT COUNT(*) as branch_count FROM branch_products WHERE product_id = ?");
                                $stmt->bind_param("i", $product['id']);
                                $stmt->execute();
                                $result = $stmt->get_result();
                                $row = $result->fetch_assoc();
                                $branch_count = $row['branch_count'];
                            ?>
                            <tr>
                                <td><?= $product['id'] ?></td>
                                <td><?= htmlspecialchars($product['code']) ?></td>
                                <td><?= htmlspecialchars($product['name']) ?></td>
                                <!-- <td><?= htmlspecialchars($product['description']) ?></td> -->
                                <!-- <td>$<?= number_format($product['price'], 2) ?></td> -->
                                <td>
                                    <span class="badge <?= $product['status'] == 'active' ? 'bg-success' : 'bg-secondary' ?>">
                                        <?= ucfirst($product['status']) ?>
                                    </span>
                                </td>
                                <td><?= $branch_count ?></td>
                                <td>
                                    <!-- Edit Button with Icon -->
                                    <a href="edit.php?id=<?= $product['id'] ?>" 
                                       class="btn btn-sm btn-primary icon-btn" 
                                       title="Edit Product">
                                        <i class="bi bi-pencil-square"></i>
                                    </a>
                                    
                                    <!-- Delete Button with Icon -->
                                    <a href="delete.php?id=<?= $product['id'] ?>" 
                                       class="btn btn-sm btn-danger icon-btn" 
                                       title="Delete Product"
                                       onclick="return confirm('Are you sure you want to delete this product?')">
                                        <i class="bi bi-trash"></i>
                                    </a>
                                </td>
                            </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <?php include '../includes/footer.php'; ?>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        const table = document.getElementById('productsTable');
        const headers = table.querySelectorAll('.sortable');
        let currentSortColumn = -1;
        let sortDirection = 'asc';
        
        headers.forEach(header => {
            header.addEventListener('click', function() {
                const columnIndex = parseInt(this.getAttribute('data-column'));
                
                // Toggle sort direction if same column is clicked
                if (columnIndex === currentSortColumn) {
                    sortDirection = sortDirection === 'asc' ? 'desc' : 'asc';
                } else {
                    sortDirection = 'asc';
                    currentSortColumn = columnIndex;
                }
                
                // Update header classes
                headers.forEach(h => {
                    h.classList.remove('sorted-asc', 'sorted-desc');
                });
                this.classList.add(sortDirection === 'asc' ? 'sorted-asc' : 'sorted-desc');
                
                // Sort the table
                sortTable(columnIndex, sortDirection);
            });
        });
        
        function sortTable(columnIndex, direction) {
            const tbody = table.querySelector('tbody');
            const rows = Array.from(tbody.querySelectorAll('tr'));
            
            // Sort rows
            rows.sort((a, b) => {
                const aValue = a.cells[columnIndex].textContent.trim();
                const bValue = b.cells[columnIndex].textContent.trim();
                
                // Case-insensitive comparison
                const comparison = aValue.localeCompare(bValue, undefined, { sensitivity: 'base' });
                
                return direction === 'asc' ? comparison : -comparison;
            });
            
            // Reorder rows in the table
            rows.forEach(row => tbody.appendChild(row));
        }
    });
    </script>
</body>
</html>