<?php
require_once '../config.php';
include 'includes/auth.php';
include_once '../includes/nav_helper.php';

$branch_id = $_SESSION['branch_id'];

// Initialize filter variables
$order_id = $_GET['order_id'] ?? '';
$start_date = $_GET['start_date'] ?? '';
$end_date = $_GET['end_date'] ?? '';
$status = $_GET['status'] ?? '';

// Build query
$query = "SELECT * FROM orders WHERE branch_id = ?";
$params = [$branch_id];
$types = 'i';

if (!empty($order_id)) {
    $query .= " AND id = ?";
    $params[] = $order_id;
    $types .= 'i';
}
if (!empty($start_date)) {
    $query .= " AND order_date >= ?";
    $params[] = $start_date;
    $types .= 's';
}
if (!empty($end_date)) {
    $query .= " AND order_date <= ?";
    $params[] = $end_date . ' 23:59:59';
    $types .= 's';
}
if (!empty($status)) {
    $query .= " AND status = ?";
    $params[] = $status;
    $types .= 's';
}
$query .= " ORDER BY order_date DESC";

$stmt = $conn->prepare($query);
$stmt->bind_param($types, ...$params);
$stmt->execute();
$recent_orders = $stmt->get_result();

// Stats
$total_orders = $conn->query("SELECT COUNT(*) FROM orders WHERE branch_id = $branch_id")->fetch_row()[0];
$pending_orders = $conn->query("SELECT COUNT(*) FROM orders WHERE branch_id = $branch_id AND status = 'pending'")->fetch_row()[0];

$statuses = ['pending', 'processed', 'shipped', 'delivered', 'cancelled'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Branch Dashboard</title>
   <link rel="stylesheet" href="../assets/css/style.css"> 
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
      table, th, td {
    font-size: 12px;
    border: 1px solid #ddd;
    padding: 12px;
}
  </style>
</head>
<body class="bg-light">
<?php include 'includes/header.php'; ?>

<div class="container py-4">
    <h1 class="mb-4">Branch Dashboard</h1>

    <!-- Stats row -->
    <div class="row mb-4">
        <div class="col-md-6">
            <div class="card shadow-sm text-center">
                <div class="card-body">
                    <h5>Total Orders</h5>
                    <h3 class="text-primary"><?= $total_orders ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card shadow-sm text-center">
                <div class="card-body">
                    <h5>Pending Orders</h5>
                    <h3 class="text-warning"><?= $pending_orders ?></h3>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <div class="card shadow-sm mb-4">
        <div class="card-header bg-secondary text-white">Filter Orders</div>
        <div class="card-body">
            <form method="get" class="row g-3">
                <div class="col-md-2">
                    <label class="form-label">Order #</label>
                    <input type="text" class="form-control" name="order_id" value="<?= htmlspecialchars($order_id) ?>">
                </div>
                <div class="col-md-3">
                    <label class="form-label">From Date</label>
                    <input type="date" class="form-control" name="start_date" value="<?= htmlspecialchars($start_date) ?>">
                </div>
                <div class="col-md-3">
                    <label class="form-label">To Date</label>
                    <input type="date" class="form-control" name="end_date" value="<?= htmlspecialchars($end_date) ?>">
                </div>
                <div class="col-md-2">
                    <label class="form-label">Status</label>
                    <select class="form-select" name="status">
                        <option value="">All</option>
                        <?php foreach ($statuses as $s): ?>
                        <option value="<?= $s ?>" <?= $status == $s ? 'selected' : '' ?>><?= ucfirst($s) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-2 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary w-100">Apply</button>
                    <a href="dashboard.php" class="btn btn-outline-secondary ms-2">Clear</a>
                </div>
            </form>
        </div>
    </div>

    <!-- Recent Orders -->
    <div class="card shadow-sm mb-4">
        <div class="card-header bg-primary text-white">Recent Orders</div>
        <div class="card-body">
            <table class="table table-striped align-middle">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Order Date</th>
                        <th>Delivery Date</th>
                        <th>Status</th>
                        <th>Total Quantity</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                <?php while ($order = $recent_orders->fetch_assoc()): ?>
                    <tr>
                        <td><?= $order['id'] ?></td>
                        <td><?= date('M j, Y', strtotime($order['order_date'])) ?></td>
                        <td><?= $order['delivery_date'] ? date('M j, Y', strtotime($order['delivery_date'])) : 'Not specified' ?></td>
                        
                             <td>
                                <span class="badge bg-<?= $order['status'] == 'pending' ? 'warning' : 'success' ?>">
                                    <?= ucfirst($order['status']) ?>
                                </span>
                            </td>
                            
                        <!-- <td><span class="badge bg-info text-dark"><?= ucfirst($order['status']) ?></span></td> -->
                        <td><?= number_format($order['total_amount']) ?></td>
                        <td>
                            <a href="orders.php?action=view&id=<?= $order['id'] ?>" class="btn btn-sm btn-info">View</a>
                        </td>
                    </tr>
                <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Quick links -->
    <div class="d-flex gap-3">
        <a href="products.php" class="btn btn-success">Place New Order</a>
        <a href="orders.php" class="btn btn-secondary">View All Orders</a>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
</body>
</html>
