<?php
require_once '../config.php';
include 'includes/auth.php';
include_once '../includes/nav_helper.php';

$branch_id = $_SESSION['branch_id'];

// Initialize filter variables
$order_id = $_GET['order_id'] ?? '';
$start_date = $_GET['start_date'] ?? '';
$end_date = $_GET['end_date'] ?? '';
$status = $_GET['status'] ?? '';

// Build query
$query = "SELECT * FROM orders WHERE branch_id = ?";
$params = [$branch_id];
$types = 'i';

if (!empty($order_id)) {
    $query .= " AND id = ?";
    $params[] = $order_id;
    $types .= 'i';
}
if (!empty($start_date)) {
    $query .= " AND order_date >= ?";
    $params[] = $start_date;
    $types .= 's';
}
if (!empty($end_date)) {
    $query .= " AND order_date <= ?";
    $params[] = $end_date . ' 23:59:59';
    $types .= 's';
}
if (!empty($status)) {
    $query .= " AND status = ?";
    $params[] = $status;
    $types .= 's';
}

$query .= " ORDER BY order_date DESC";
$stmt = $conn->prepare($query);
$stmt->bind_param($types, ...$params);
$stmt->execute();
$orders = $stmt->get_result();

$statuses = ['pending','processed','shipped','delivered','cancelled'];

// View details
if (isset($_GET['action'], $_GET['id']) && $_GET['action'] == 'view') {
    $order_id = $_GET['id'];
    $stmt = $conn->prepare("SELECT * FROM orders WHERE id = ? AND branch_id = ?");
    $stmt->bind_param("ii", $order_id, $branch_id);
    $stmt->execute();
    $order_result = $stmt->get_result();

    if ($order_result->num_rows === 1) {
        $order = $order_result->fetch_assoc();

        $stmt = $conn->prepare("
            SELECT oi.*, p.code AS product_code, p.name AS product_name 
            FROM order_items oi 
            JOIN products p ON oi.product_id = p.id 
            WHERE oi.order_id = ?
        ");
        $stmt->bind_param("i", $order_id);
        $stmt->execute();
        $items = $stmt->get_result();
        ?>
        <!DOCTYPE html>
        <html lang="en">
        <head>
            <meta charset="UTF-8">
            <title>Order Details</title>
            <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
            <link rel="stylesheet" href="../assets/css/style.css">
        </head>
        <body class="bg-light">
        <?php include 'includes/header.php'; ?>
        <div class="container py-5">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white">
                    <h4 class="mb-0">Order #<?= $order_id ?></h4>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-md-6"><strong>Order Date:</strong> <?= date('F j, Y', strtotime($order['order_date'])) ?></div>
                        <div class="col-md-6"><strong>Delivery Date:</strong> <?= $order['delivery_date'] ? date('F j, Y', strtotime($order['delivery_date'])) : 'Not specified' ?></div>
                        
                                <div class="col-md-6"><strong>Status:</strong><span class="badge bg-<?= $order['status'] == 'pending' ? 'warning' : 'success' ?>">
                                    <?= ucfirst($order['status']) ?>
                                </span> </div>
                        
                            
                        <!-- <div class="col-md-6"><strong>Status:</strong> <?= ucfirst($order['status']) ?></div> -->
                        <div class="col-md-6"><strong>Order Quantity:</strong> <?= number_format($order['total_amount'], 2) ?></div>
                    </div>

                    <h5>Order Items</h5>
                    <div class="table-responsive">
                        <table class="table table-striped table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>Product Code</th>
                                    <th>Product</th>
                                    <th>Quantity</th>
                                    <!-- <th>Price</th> -->
                                    <!-- <th>Total</th> -->
                                </tr>
                            </thead>
                            <tbody>
                            <?php while ($item = $items->fetch_assoc()): ?>
                                <tr>
                                    <td><?= htmlspecialchars($item['product_code']) ?></td>
                                    <td><?= htmlspecialchars($item['product_name']) ?></td>
                                    <td><?= $item['quantity'] ?></td>
                                    <!-- <td>$<?= number_format($item['price'], 2) ?></td> -->
                                    <!-- <td>$<?= number_format($item['quantity'] * $item['price'], 2) ?></td> -->
                                </tr>
                            <?php endwhile; ?>
                            </tbody>
                        </table>
                    </div>

                    <!-- <a href="orders.php<?= !empty($_GET) ? '?' . http_build_query($_GET) : '' ?>" class="btn btn-secondary">⬅ Back to Orders</a> -->
                    <a href="orders.php" class="btn btn-secondary">⬅ Back to Orders</a>
                </div>
            </div>
        </div>
        <?php include 'includes/footer.php'; ?>
        </body>
        </html>
        <?php exit();
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Order History</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body class="bg-light">
<?php include 'includes/header.php'; ?>
<div class="container py-5">
    <div class="card shadow-sm mb-4">
        <div class="card-header bg-primary text-white">
            <h4 class="mb-0">Order History</h4>
        </div>
        <div class="card-body">
            <form method="get" class="row g-3">
                <div class="col-md-2">
                    <label for="order_id" class="form-label">Order #</label>
                    <input type="text" id="order_id" name="order_id" value="<?= htmlspecialchars($order_id) ?>" class="form-control">
                </div>
                <div class="col-md-3">
                    <label for="start_date" class="form-label">From Date</label>
                    <input type="date" id="start_date" name="start_date" value="<?= htmlspecialchars($start_date) ?>" class="form-control">
                </div>
                <div class="col-md-3">
                    <label for="end_date" class="form-label">To Date</label>
                    <input type="date" id="end_date" name="end_date" value="<?= htmlspecialchars($end_date) ?>" class="form-control">
                </div>
                <div class="col-md-2">
                    <label for="status" class="form-label">Status</label>
                    <select id="status" name="status" class="form-select">
                        <option value="">All</option>
                        <?php foreach ($statuses as $s): ?>
                            <option value="<?= $s ?>" <?= $status == $s ? 'selected' : '' ?>><?= ucfirst($s) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-2 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary me-2">Apply</button>
                    <a href="orders.php" class="btn btn-outline-secondary">Clear</a>
                </div>
            </form>
        </div>
    </div>

    <div class="card shadow-sm">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-striped table-hover">
                    <thead class="table-light">
                        <tr>
                            <th>ID</th>
                            <th>Order Date</th>
                            <th>Delivery Date</th>
                            <th>Status</th>
                            <th>Total Quantity</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php while ($order = $orders->fetch_assoc()): ?>
                        <tr>
                            <td><?= $order['id'] ?></td>
                            <td><?= date('M j, Y', strtotime($order['order_date'])) ?></td>
                            <td><?= $order['delivery_date'] ? date('M j, Y', strtotime($order['delivery_date'])) : 'Not specified' ?></td>
                             <td>
                                <span class="badge bg-<?= $order['status'] == 'pending' ? 'warning' : 'success' ?>">
                                    <?= ucfirst($order['status']) ?>
                                </span>
                            </td>
                            <!-- <td><?= ucfirst($order['status']) ?></td> -->
                            <td><?= number_format($order['total_amount']) ?></td>
                           <td><a href="?action=view&id=<?= $order['id'] ?><?= !empty($_GET) ? '&' . http_build_query($_GET) : '' ?>" class="btn btn-sm btn-info">View</a></td>

                        </tr>
                    <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php include 'includes/footer.php'; ?>
</body>
</html>
