<!DOCTYPE html>
<html>
<head>
    <title>B2B Admin Panel</title>
    <link rel="stylesheet" href="../../assets/css/style.css">
    <style>
        /* Navigation menu styles */
        .nav-menu {
            display: flex;
            list-style: none;
            margin: 0;
            padding: 0;
            background-color: #444;
        }
        
        .nav-menu li {
            position: relative;
        }
        
        .nav-menu li a {
            display: block;
            padding: 15px 20px;
            color: white;
            text-decoration: none;
            transition: background-color 0.3s;
        }
        
        .nav-menu li a:hover {
            background-color: #555;
        }
        
        .nav-menu li.active a {
            background-color: #4CAF50;
        }
        
        .dropdown {
            position: absolute;
            top: 100%;
            left: 0;
            background-color: #444;
            min-width: 200px;
            box-shadow: 0 8px 16px rgba(0,0,0,0.2);
            z-index: 1;
            display: none;
        }
        
        .nav-menu li:hover .dropdown {
            display: block;
        }
        
        .dropdown li a {
            padding: 12px 20px;
        }
        
        .header-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .user-info {
            padding: 0 20px;
        }
    </style>
</head>
<body>
    <div class="header">
        <ul class="nav-menu">
            <li><a href="/admin/dashboard.php">Dashboard</a></li>
            <li>
                <a href="#">Management</a>
                <ul class="dropdown">
                    <li><a href="/admin/company/index.php">Manage Companies</a></li>
                    <li><a href="/admin/customers/index.php">Manage Customers</a></li>
                    <li><a href="/admin/branches/index.php">Manage Branches</a></li>
                    <li><a href="/admin/products/index.php">Manage Products</a></li>
                    <li><a href="/admin/mappings/index.php">Product Mappings</a></li>
                </ul>
            </li>
               <li>
                <a href="#">Orders</a>
                <ul class="dropdown">
                <li><a href="/admin/orders/index.php">View Orders</a></li>
                <li><a href="/admin/orders/orders.php">Place Order</a></li>
                <li><a href="/admin/orders/saplog.php">SAP Integration Log</a></li>
                </ul>
            </li>
        </ul>
            <div class="header-content">
            <div class="user-info">
                Welcome, <?= htmlspecialchars($_SESSION['admin_name']) ?> | 
                <a href="/admin/logout.php">Logout</a>
            </div>
        </div>

    </div>
 
    <?php
    // Include the nav helper functions
//   include_once '../includes/nav_helper.php';
include_once(__DIR__ . '/../../includes/nav_helper.php');

    ?>