<?php
require_once '../../config.php';
include '../includes/auth.php';
include_once '../../includes/nav_helper.php';

$branch_id = $_POST['branch_id'];

// Check order
if (!isset($_GET['order_id'])) {
    header("Location: orders.php");
    exit();
}

$order_id = $_GET['order_id'];

$stmt = $conn->prepare("SELECT * FROM orders WHERE id = ? AND branch_id = ?");
$stmt->bind_param("ii", $order_id, $branch_id);
$stmt->execute();
$order_result = $stmt->get_result();

if ($order_result->num_rows !== 1) {
    header("Location: index.php");
    exit();
}
$order = $order_result->fetch_assoc();

// Items
$stmt = $conn->prepare("
    SELECT oi.*, p.code AS product_code, p.name AS product_name 
    FROM order_items oi 
    JOIN products p ON oi.product_id = p.id 
    WHERE oi.order_id = ?
");
$stmt->bind_param("i", $order_id);
$stmt->execute();
$items = $stmt->get_result();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Order Confirmation</title>
    <link rel="stylesheet" href="../../assets/css/style.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<?php include '../includes/header.php'; ?>

<div class="container py-5">
    <div class="card shadow-sm">
        <div class="card-header bg-success text-white">
            <h4 class="mb-0">Order Confirmation</h4>
        </div>
        <div class="card-body">
            <div class="alert alert-success">
                ✅ Thank you! Your order has been placed successfully.
            </div>

            <!-- Order Info in two columns -->
            <div class="row mb-4">
                <div class="col-md-6">
                    <p><strong>Order ID:</strong> #<?= $order_id ?></p>
                    <p><strong>Order Date:</strong> <?= date('F j, Y', strtotime($order['order_date'])) ?></p>
                    <p><strong>Status:</strong> 
                        <span class="badge bg-info text-dark"><?= ucfirst($order['status']) ?></span>
                    </p>
                </div>
                <div class="col-md-6">
                    <p><strong>Delivery Date:</strong> 
                        <?= $order['delivery_date'] ? date('F j, Y', strtotime($order['delivery_date'])) : 'Not specified' ?>
                    </p>
                    <p><strong>Total Order Quanity:</strong> 
                        <span class="fw-bold text-primary"><?= number_format($order['total_amount'], 2) ?></span>
                    </p>
                </div>
            </div>

            <h5>Order Items</h5>
            <table class="table table-striped table-bordered align-middle mt-3">
                <thead class="table-light">
                    <tr>
                        <th>Product Code</th>
                        <th>Product</th>
                        <th width="120">Quantity</th>
                        <!-- <th width="120">Price</th> -->
                        <!-- <th width="120">Total</th> -->
                    </tr>
                </thead>
                <tbody>
                <?php while ($item = $items->fetch_assoc()): ?>
                    <tr>
                        <td><?= htmlspecialchars($item['product_code']) ?></td>
                        <td><?= htmlspecialchars($item['product_name']) ?></td>
                        <td><?= $item['quantity'] ?></td>
                        <!-- <td>$<?= number_format($item['price'], 2) ?></td> -->
                        <!-- <td>$<?= number_format($item['quantity'] * $item['price'], 2) ?></td> -->
                    </tr>
                <?php endwhile; ?>
                </tbody>
            </table>

            <div class="d-flex gap-3 mt-4">
                <a href="orders.php" class="btn btn-secondary">📋 View Order History</a>
                <a href="products.php" class="btn btn-primary">🛒 Continue Shopping</a>
            </div>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>
</body>
</html>
