<?php
require_once '../../config.php';
include '../includes/auth.php';

if (!isset($_GET['id'])) {
    header("Location: index.php");
    exit();
}

$order_id = $_GET['id'];

// Get order details
$stmt = $conn->prepare("
    SELECT o.*, b.name AS branch_name 
    FROM orders o 
    JOIN branches b ON o.branch_id = b.id 
    WHERE o.id = ?
");
$stmt->bind_param("i", $order_id);
$stmt->execute();
$order_result = $stmt->get_result();

if ($order_result->num_rows === 1) {
    $order = $order_result->fetch_assoc();
} else {
    header("Location: index.php");
    exit();
}

// Get order items
$stmt = $conn->prepare("
    SELECT oi.*, p.code as sap_code, p.name AS product_name 
    FROM order_items oi 
    JOIN products p ON oi.product_id = p.id 
    WHERE oi.order_id = ?
");
$stmt->bind_param("i", $order_id);
$stmt->execute();
$items = $stmt->get_result();

// Update status if form submitted
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $status = $_POST['status'];
    $delivery_date = $_POST['delivery_date'];
    
    $stmt = $conn->prepare("UPDATE orders SET status=?, delivery_date=? WHERE id=?");
    $stmt->bind_param("ssi", $status, $delivery_date, $order_id);
    $stmt->execute();
    
    header("Location: view.php?id=$order_id&success=1");
    exit();
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Order Details</title>
    <link rel="stylesheet" href="../../assets/css/style.css">
    <!-- Bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<?php include '../includes/header.php'; ?>
<div class="container mt-4">
    
    <!-- Order Header -->
    <div class="card mb-4">
        <div class="card-header bg-primary text-white">
            <h4 class="mb-0">📄 Order #<?= $order_id ?></h4>
        </div>
        <div class="card-body">
            <div class="row">
                <!-- Left Column -->
                <div class="col-md-6">
                    <p><strong>Branch:</strong> <?= htmlspecialchars($order['branch_name']) ?></p>
                    <p><strong>Order Date:</strong> <?= date('F j, Y', strtotime($order['order_date'])) ?></p>
                    <p><strong>Delivery Date:</strong> 
                        <?= $order['delivery_date'] ? date('F j, Y', strtotime($order['delivery_date'])) : 'Not specified' ?>
                    </p>
                </div>
                <!-- Right Column -->
                <div class="col-md-6">
                    <p><strong>Status:</strong> 
                        <span class="badge bg-<?= $order['status'] == 'delivered' ? 'success' : ($order['status'] == 'cancelled' ? 'danger' : 'warning') ?>">
                            <?= ucfirst($order['status']) ?>
                        </span>
                    </p>
                    <p><strong>Order Quanity:</strong> 
                        <span class="fw-bold text-success"><?= number_format($order['total_amount'], 0) ?></span>
                    </p>
                </div>
            </div>
        </div>
    </div>

    <!-- Order Items -->
    <div class="card mb-4">
        <div class="card-header bg-secondary text-white">
            <h5 class="mb-0">🛒 Order Items</h5>
        </div>
        <div class="card-body">
            <table class="table table-bordered table-striped">
                <thead class="table-dark">
                    <tr>
                        <th>SAP Code</th>
                        <th>Product</th>
                        <th class="text-center">Quantity</th>
                        <!-- <th class="text-end">Price</th> -->
                        <!-- <th class="text-end">Total</th> -->
                    </tr>
                </thead>
                <tbody>
                <?php while ($item = $items->fetch_assoc()): ?>
                    <tr>
                        <td><?= htmlspecialchars($item['sap_code']) ?></td>
                        <td><?= htmlspecialchars($item['product_name']) ?></td>
                        <td class="text-center"><?= $item['quantity'] ?></td>
                        <!-- <td class="text-end">$<?= number_format($item['price'], 2) ?></td> -->
                        <!-- <td class="text-end">$<?= number_format($item['quantity'] * $item['price'], 2) ?></td> -->
                    </tr>
                <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Update Order -->
    <div class="card mb-4">
        <div class="card-header bg-info text-white">
            <h5 class="mb-0">✏️ Update Order</h5>
        </div>
        <div class="card-body">
            <form method="post" class="row g-3">
                <div class="col-md-6">
                    <label class="form-label">Status:</label>
                    <select name="status" class="form-select">
                        <option value="pending" <?= $order['status'] == 'pending' ? 'selected' : '' ?>>Pending</option>
                        <option value="processed" <?= $order['status'] == 'processed' ? 'selected' : '' ?>>Processed</option>
                        <option value="shipped" <?= $order['status'] == 'shipped' ? 'selected' : '' ?>>Shipped</option>
                        <option value="delivered" <?= $order['status'] == 'delivered' ? 'selected' : '' ?>>Delivered</option>
                        <option value="cancelled" <?= $order['status'] == 'cancelled' ? 'selected' : '' ?>>Cancelled</option>
                    </select>
                </div>
                <div class="col-md-6">
                    <label for="delivery_date" class="form-label">Delivery Date:</label>
                    <input type="date" name="delivery_date" id="delivery_date" value="<?= $order['delivery_date'] ?>" class="form-control">
                </div>
                <div class="col-12">
                    <button type="submit" class="btn btn-success">✅ Update Order</button>
                    <a href="index.php" class="btn btn-secondary">⬅ Back to Orders</a>
                </div>
            </form>
        </div>
    </div>

</div>
<?php include '../includes/footer.php'; ?>
</body>
</html>
