<?php
require_once '../../config.php';
include '../includes/auth.php';
if (!isset($_GET['id'])) {
    header("Location: index.php");
    exit();
}
$branch_id = $_GET['id'];

// Get companies for dropdown
$companies = $conn->query("SELECT id, name FROM company ORDER BY name");

// Get customers for dropdown
$customers = $conn->query("SELECT id, name FROM customers ORDER BY name");

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $name = $_POST['name'];
    $email = $_POST['email'];
    $address = $_POST['address'];
    $contact_person = $_POST['contact_person'];
    $phone = $_POST['phone'];
    $code = $_POST['code'];
    $status = $_POST['status'];
    $company = $_POST['company'];
    $master_customer = $_POST['master_customer'];
    
    // Check if email already exists (excluding current branch)
    $stmt = $conn->prepare("SELECT id FROM branches WHERE email = ? AND id != ?");
    $stmt->bind_param("si", $email, $branch_id);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result->num_rows > 0) {
        $error = "Email already exists. Please use a different email.";
    }
    // Check if branch code already exists (excluding current branch)
    if (!isset($error) && !empty($code)) {
        $stmt = $conn->prepare("SELECT id FROM branches WHERE code = ? AND id != ?");
        $stmt->bind_param("si", $code, $branch_id);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($result->num_rows > 0) {
            $error = "Branch Code already exists. Please use a different code.";
        }
    }
    if (!isset($error)) {
        // Update password only if provided
        if (!empty($_POST['password'])) {
            $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
            $stmt = $conn->prepare("UPDATE branches SET name=?, email=?, password=?, address=?, contact_person=?, phone=?, code=?, status=?, company=?, master_customer=? WHERE id=?");
            $stmt->bind_param("ssssssssiii", $name, $email, $password, $address, $contact_person, $phone, $code, $status, $company, $master_customer, $branch_id);
        } else {
            $stmt = $conn->prepare("UPDATE branches SET name=?, email=?, address=?, contact_person=?, phone=?, code=?, status=?, company=?, master_customer=? WHERE id=?");
            $stmt->bind_param("sssssssiii", $name, $email, $address, $contact_person, $phone, $code, $status, $company, $master_customer, $branch_id);
        }
        if ($stmt->execute()) {
            header("Location: index.php?success=1");
            exit();
        } else {
            $error = "Error updating branch";
        }
    }
} else {
    $stmt = $conn->prepare("SELECT * FROM branches WHERE id=?");
    $stmt->bind_param("i", $branch_id);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result->num_rows === 1) {
        $branch = $result->fetch_assoc();
    } else {
        header("Location: index.php");
        exit();
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Edit Branch</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background-color: #f8f9fa; }
        .card { border-radius: 1rem; box-shadow: 0 0.5rem 1rem rgba(0,0,0,.05); }
        .btn { border-radius: .5rem; }
    </style>
</head>
<body>
<?php include '../includes/header.php'; ?>
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <div class="card">
                <div class="card-body">
                    <h1 class="h4 mb-4">✏️ Edit Branch</h1>
                    <?php if (isset($error)): ?>
                        <div class="alert alert-danger"><?= $error ?></div>
                    <?php endif; ?>
                    <form method="post">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label">Name:</label>
                                <input type="text" name="name" value="<?= htmlspecialchars($branch['name']) ?>" class="form-control" required>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Email:</label>
                                <input type="email" name="email" value="<?= htmlspecialchars($branch['email']) ?>" class="form-control" required>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Password (leave blank to keep current):</label>
                                <input type="password" name="password" class="form-control">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Contact Person:</label>
                                <input type="text" name="contact_person" value="<?= htmlspecialchars($branch['contact_person']) ?>" class="form-control">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Phone:</label>
                                <input type="text" name="phone" value="<?= htmlspecialchars($branch['phone']) ?>" class="form-control">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Branch Code:</label>
                                <input type="text" name="code" value="<?= htmlspecialchars($branch['code']) ?>" class="form-control">
                                <div class="form-text">Branch Code must be unique</div>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Company:</label>
                                <select name="company" class="form-select" required>
                                    <option value="">Select Company</option>
                                    <?php 
                                    $companies->data_seek(0);
                                    while ($company = $companies->fetch_assoc()): 
                                    ?>
                                        <option value="<?= $company['id'] ?>" <?= $branch['company'] == $company['id'] ? 'selected' : '' ?>>
                                            <?= htmlspecialchars($company['name']) ?>
                                        </option>
                                    <?php endwhile; ?>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Master Customer:</label>
                                <select name="master_customer" class="form-select" required>
                                    <option value="">Select Customer</option>
                                    <?php 
                                    $customers->data_seek(0);
                                    while ($customer = $customers->fetch_assoc()): 
                                    ?>
                                        <option value="<?= $customer['id'] ?>" <?= $branch['master_customer'] == $customer['id'] ? 'selected' : '' ?>>
                                            <?= htmlspecialchars($customer['name']) ?>
                                        </option>
                                    <?php endwhile; ?>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Status:</label>
                                <select name="status" class="form-select">
                                    <option value="active" <?= $branch['status'] == 'active' ? 'selected' : '' ?>>Active</option>
                                    <option value="inactive" <?= $branch['status'] == 'inactive' ? 'selected' : '' ?>>Inactive</option>
                                </select>
                            </div>
                            <div class="col-md-12">
                                <label class="form-label">Address:</label>
                                <textarea name="address" class="form-control" rows="2"><?= htmlspecialchars($branch['address']) ?></textarea>
                            </div>
                        </div>
                        <div class="d-flex justify-content-between mt-4">
                            <button type="submit" class="btn btn-primary">💾 Update Branch</button>
                            <a href="index.php" class="btn btn-secondary">↩ Cancel</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php include '../includes/footer.php'; ?>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>