<?php
require_once '../../config.php';
include '../includes/auth.php';
// Get all branches
$branches = $conn->query("SELECT * FROM branches ORDER BY code");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Manage Branches</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <style>
        body {
            background-color: #f8f9fa;
        }
        h1 {
            font-size: 1rem;
            font-weight: 600;
        }
        .card {
            border-radius: 1rem;
            box-shadow: 0 0.5rem 1rem rgba(0,0,0,.05);
        }
        .btn {
            border-radius: .5rem;
        }
        .table {
            font-size: 0.85rem;
        }
        .icon-btn {
            padding: 0.25rem 0.5rem;
            margin: 0 0.1rem;
        }
        /* Sortable header styles */
        .sortable {
            cursor: pointer;
            position: relative;
            padding-right: 25px !important;
        }
        .sortable:hover {
            background-color: rgba(255,255,255,0.1);
        }
        .sort-icon {
            position: absolute;
            right: 8px;
            top: 50%;
            transform: translateY(-50%);
            opacity: 0.5;
        }
        .sorted-asc .sort-icon:before {
            content: "\F233"; /* Bootstrap icon for arrow-up-short */
        }
        .sorted-desc .sort-icon:before {
            content: "\F236"; /* Bootstrap icon for arrow-down-short */
        }
        .sorted-asc .sort-icon, 
        .sorted-desc .sort-icon {
            opacity: 1;
        }
    </style>
</head>
<body>
<?php include '../includes/header.php'; ?>
<div class="container py-4">
    <h1 class="mb-4">🏢 Manage Branches</h1>
    <!-- Action Button -->
    <div class="mb-3">
        <a href="add.php" class="btn btn-primary">
            <i class="bi bi-plus-circle"></i> Add New Branch
        </a>
    </div>
    <!-- Branches Table -->
    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover align-middle" id="branchesTable">
                    <thead class="table-dark">
                    <tr>
                        <th>ID</th>
                        <th class="sortable" data-column="1">
                            Name
                            <i class="bi sort-icon"></i>
                        </th>
                        <th class="sortable" data-column="2">
                            Branch Code
                            <i class="bi sort-icon"></i>
                        </th>
                        <th>Email</th>
                        <th>Contact Person</th>
                        <th>Phone</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php while ($branch = $branches->fetch_assoc()): ?>
                        <tr>
                            <td><?= $branch['id'] ?></td>
                            <td><?= htmlspecialchars($branch['name']) ?></td>
                            <td><?= htmlspecialchars($branch['code']) ?></td>
                            <td><?= htmlspecialchars($branch['email']) ?></td>
                            <td><?= htmlspecialchars($branch['contact_person']) ?></td>
                            <td><?= htmlspecialchars($branch['phone']) ?></td>
                            <td>
                                <?php if ($branch['status'] === 'active'): ?>
                                    <span class="badge bg-success">Active</span>
                                <?php else: ?>
                                    <span class="badge bg-secondary">Inactive</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <a href="edit.php?id=<?= $branch['id'] ?>" 
                                   class="btn btn-sm btn-primary icon-btn" 
                                   title="Edit Branch">
                                    <i class="bi bi-pencil-square"></i>
                                </a>
                                <a href="delete.php?id=<?= $branch['id'] ?>" 
                                   class="btn btn-sm btn-danger icon-btn" 
                                   title="Delete Branch"
                                   onclick="return confirm('Are you sure you want to delete this branch?')">
                                    <i class="bi bi-trash"></i>
                                </a>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php include '../includes/footer.php'; ?>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const table = document.getElementById('branchesTable');
    const headers = table.querySelectorAll('.sortable');
    let currentSortColumn = -1;
    let sortDirection = 'asc';
    
    headers.forEach(header => {
        header.addEventListener('click', function() {
            const columnIndex = parseInt(this.getAttribute('data-column'));
            
            // Toggle sort direction if same column is clicked
            if (columnIndex === currentSortColumn) {
                sortDirection = sortDirection === 'asc' ? 'desc' : 'asc';
            } else {
                sortDirection = 'asc';
                currentSortColumn = columnIndex;
            }
            
            // Update header classes
            headers.forEach(h => {
                h.classList.remove('sorted-asc', 'sorted-desc');
            });
            this.classList.add(sortDirection === 'asc' ? 'sorted-asc' : 'sorted-desc');
            
            // Sort the table
            sortTable(columnIndex, sortDirection);
        });
    });
    
    function sortTable(columnIndex, direction) {
        const tbody = table.querySelector('tbody');
        const rows = Array.from(tbody.querySelectorAll('tr'));
        
        // Sort rows
        rows.sort((a, b) => {
            const aValue = a.cells[columnIndex].textContent.trim();
            const bValue = b.cells[columnIndex].textContent.trim();
            
            // Case-insensitive comparison
            const comparison = aValue.localeCompare(bValue, undefined, { sensitivity: 'base' });
            
            return direction === 'asc' ? comparison : -comparison;
        });
        
        // Reorder rows in the table
        rows.forEach(row => tbody.appendChild(row));
    }
});
</script>
</body>
</html>