<?php
require_once '../../config.php';
include '../includes/auth.php';

if (!isset($_GET['branch_id'])) {
    header("Location: index.php");
    exit();
}

$branch_id = $_GET['branch_id'];

// Get branch details
$stmt = $conn->prepare("SELECT * FROM branches WHERE id = ?");
$stmt->bind_param("i", $branch_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows !== 1) {
    header("Location: index.php");
    exit();
}
$branch = $result->fetch_assoc();

// Get all products
$products = $conn->query("SELECT * FROM products WHERE status = 'active' ORDER BY name");

// Get currently mapped products
$mapped_products = [];
$stmt = $conn->prepare("SELECT product_id FROM branch_products WHERE branch_id = ?");
$stmt->bind_param("i", $branch_id);
$stmt->execute();
$result = $stmt->get_result();
while ($row = $result->fetch_assoc()) {
    $mapped_products[] = $row['product_id'];
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Clear existing mappings
    $stmt = $conn->prepare("DELETE FROM branch_products WHERE branch_id = ?");
    $stmt->bind_param("i", $branch_id);
    $stmt->execute();
    
    // Insert new mappings
    if (isset($_POST['products'])) {
        $stmt = $conn->prepare("INSERT INTO branch_products (branch_id, product_id) VALUES (?, ?)");
        foreach ($_POST['products'] as $product_id) {
            $stmt->bind_param("ii", $branch_id, $product_id);
            $stmt->execute();
        }
    }
    
    header("Location: index.php?success=1");
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Edit Product Mappings</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background-color: #f8f9fa; }
        .card { border-radius: 1rem; box-shadow: 0 0.5rem 1rem rgba(0,0,0,.05); }
        .btn { border-radius: .5rem; }
    </style>
</head>
<body>
    <?php include '../includes/header.php'; ?>

    <div class="container py-5">
        <div class="card">
            <div class="card-header bg-primary text-white">
                <h4 class="mb-0">📦 Edit Product Mappings for: <?= htmlspecialchars($branch['name']) ?></h4>
            </div>
            <div class="card-body">
                <form method="post">
                    <div class="table-responsive">
                        <table class="table table-striped table-hover align-middle">
                            <thead class="table-light">
                                <tr>
                                    <th scope="col">Select</th>
                                    <th scope="col">Product Code</th>
                                    <th scope="col">Product</th>
                                    <th scope="col">Description</th>
                                    <th scope="col">Price</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php while ($product = $products->fetch_assoc()): ?>
                                <tr>
                                    <td>
                                        <input class="form-check-input" type="checkbox" name="products[]" 
                                               value="<?= $product['id'] ?>" 
                                               <?= in_array($product['id'], $mapped_products) ? 'checked' : '' ?>>
                                    </td>
                                    <td><?= htmlspecialchars($product['code']) ?></td>
                                    <td><?= htmlspecialchars($product['name']) ?></td>
                                    <td><?= htmlspecialchars($product['description']) ?></td>
                                    <td>$<?= number_format($product['price'], 2) ?></td>
                                </tr>
                                <?php endwhile; ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="d-flex justify-content-between mt-4">
                        <a href="index.php" class="btn btn-secondary">⬅ Cancel</a>
                        <button type="submit" class="btn btn-success">💾 Save Mappings</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <?php include '../includes/footer.php'; ?>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
