<?php
function generateSAPSoapXML($orderData) {
    // Create DOM document
    $dom = new DOMDocument('1.0', 'UTF-8');
    $dom->formatOutput = true;
    $dom->preserveWhiteSpace = false;
    
    // Create SOAP Envelope
    $envelope = $dom->createElementNS('http://schemas.xmlsoap.org/soap/envelope/', 'soapenv:Envelope');
    $envelope->setAttributeNS('http://www.w3.org/2000/xmlns/', 'xmlns:urn', 'urn:sap-com:document:sap:rfc:functions');
    $dom->appendChild($envelope);
    
    // Create Header
    $header = $dom->createElement('soapenv:Header');
    $envelope->appendChild($header);
    
    // Create Body
    $body = $dom->createElement('soapenv:Body');
    $envelope->appendChild($body);
    
    // Create SAP function
    $sapFunction = $dom->createElement('urn:ZTA_SAP_KFC_SO_INTEGRATION');
    $body->appendChild($sapFunction);
    
    // Add basic order elements
    foreach ($orderData['order'] as $order) {
        $sapFunction->appendChild($dom->createElement('PORTAL_ID', $order['portal_id']));
        $sapFunction->appendChild($dom->createElement('KUNNR', $order['branch_code']));
        $sapFunction->appendChild($dom->createElement('PLANT', $order['plant']));
        $sapFunction->appendChild($dom->createElement('SALES_ORG', $order['sales_org']));
        $sapFunction->appendChild($dom->createElement('AUART', $order['order_type']));
        $sapFunction->appendChild($dom->createElement('DATE', $order['date']));
    }    
    
    // Add item details
    $itemDetail = $dom->createElement('ITEM_DETAIL');
    $sapFunction->appendChild($itemDetail);
    
    foreach ($orderData['items'] as $item) {
        $itemNode = $dom->createElement('item');
        $itemDetail->appendChild($itemNode);
        
        $itemNode->appendChild($dom->createElement('MATERIAL', $item['material']));
        $itemNode->appendChild($dom->createElement('TARGET_QTY', $item['target_qty']));
        $itemNode->appendChild($dom->createElement('STORE_LOC', $item['store_loc']));
    }
    
    return $dom->saveXML();
}
?>
