<!DOCTYPE html>
<html>
<head>
    <title>B2B Branch Portal</title>
    <link rel="stylesheet" href="../../assets/css/style.css">
    <style>
        /* Navigation menu styles */
        .nav-menu {
            display: flex;
            list-style: none;
            margin: 0;
            padding: 0;
            background-color: #444;
        }
        
        .nav-menu li {
            position: relative;
        }
        
        .nav-menu li a {
            display: block;
            padding: 15px 20px;
            color: white;
            text-decoration: none;
            transition: background-color 0.3s;
        }
        
        .nav-menu li a:hover {
            background-color: #555;
        }
        
        .nav-menu li.active a {
            background-color: #4CAF50;
        }
        
        .header-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .user-info {
            padding: 0 20px;
        }
        
        .cart-link {
            position: relative;
        }
        
        .cart-count {
            position: absolute;
            top: 5px;
            right: 5px;
            background-color: #f44336;
            color: white;
            border-radius: 50%;
            padding: 2px 6px;
            font-size: 12px;
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="header-content">
            <h1>B2B Branch Portal</h1>
            <div class="user-info">
                Welcome, <?= htmlspecialchars($_SESSION['branch_name']) ?> | 
                <a href="logout.php">Logout</a>
            </div>
        </div>
        <ul class="nav-menu">
            <li class="<?= setActive('dashboard.php') ?>"><a href="dashboard.php">Dashboard</a></li>
            <li class="<?= setActive('products.php') ?>"><a href="products.php">Place Order</a></li>
            <li class="<?= setActive('orders.php') ?>"><a href="orders.php">Order History</a></li>
        </ul>
    </div>
    
    <?php
    // Include the nav helper functions
//    include_once '../../includes/nav_helper.php';
include_once(__DIR__ . '/../../includes/nav_helper.php');
    ?>