<?php
require_once '../config.php';
include 'includes/auth.php';
include_once '../includes/nav_helper.php';
include_once '../includes/excel_export.php';
// Get statistics
$company_code = ($_SESSION['company_code']);
if (empty($company_code)) {
    $total_branches = $conn->query("SELECT COUNT(*) FROM branches WHERE status = 'active'")->fetch_row()[0];
    $total_orders   = $conn->query("SELECT COUNT(*) FROM orders")->fetch_row()[0];
    $pending_orders = $conn->query("SELECT COUNT(*) FROM orders WHERE status = 'pending'")->fetch_row()[0];
    } 
else
    {
    $total_branches = $conn->query("SELECT COUNT(*) FROM branches WHERE company = $company_code and status = 'active'")->fetch_row()[0];
    $total_orders   = $conn->query("SELECT COUNT(*) FROM orders o JOIN branches b ON o.branch_id = b.id WHERE b.company = $company_code")->fetch_row()[0];
    $pending_orders = $conn->query("SELECT COUNT(*) FROM orders o JOIN branches b ON o.branch_id = b.id WHERE b.company = $company_code and  o.status = 'pending'")->fetch_row()[0];
    }


// Filters
$branch_name= $_GET['branch_name'] ?? '';
$order_id   = $_GET['order_id'] ?? '';
$start_date = $_GET['start_date'] ?? '';
$end_date   = $_GET['end_date'] ?? '';
$status     = $_GET['status'] ?? '';
$query = "
    SELECT o.*, b.name AS branch_name, b.code AS branch_code, b.company
    FROM orders o
    JOIN branches b ON o.branch_id = b.id
    WHERE 1=1
";
$params = [];
$types = '';
if (!empty($company_code)) {
    $query .= " AND b.company = ?";
    $params[] = $company_code;
    $types .= 'i';
}
if (!empty($branch_name)) {
    $query .= " AND b.name like ?";
    $params[] = "%$branch_name%";
    $types .= 's';
}
if (!empty($order_id)) {
    $query .= " AND o.id = ?";
    $params[] = $order_id;
    $types .= 'i';
}
if (!empty($start_date)) {
    $query .= " AND o.order_date >= ?";
    $params[] = $start_date;
    $types .= 's';
}
if (!empty($end_date)) {
    $query .= " AND o.order_date <= ?";
    $params[] = $end_date . ' 23:59:59';
    $types .= 's';
}
if (!empty($status)) {
    $query .= " AND o.status = ?";
    $params[] = $status;
    $types .= 's';
}
$query .= " ORDER BY o.order_date DESC, o.id DESC LIMIT 50";
// Execute query6
if (!empty($params)) {
    $stmt = $conn->prepare($query);
    $stmt->bind_param($types, ...$params);
    $stmt->execute();
    $recent_orders = $stmt->get_result();
} else {
    $recent_orders = $conn->query($query);
}
$statuses = ['pending', 'processed', 'shipped', 'delivered', 'cancelled'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<?php include 'includes/header.php'; ?>
<div class="container my-5">
    <h1 class="mb-4">Admin Dashboard</h1>
    <!-- Stats -->
    <div class="row text-center mb-4">
        <div class="col-md-4 mb-3">
            <div class="card shadow-sm">
                <div class="card-body">
                    <h5>Total Branches</h5>
                    <p class="fs-3 fw-bold"><?= $total_branches ?></p>
                </div>
            </div>
        </div>
        <div class="col-md-4 mb-3">
            <div class="card shadow-sm">
                <div class="card-body">
                    <h5>Total Orders</h5>
                    <p class="fs-3 fw-bold"><?= $total_orders ?></p>
                </div>
            </div>
        </div>
        <div class="col-md-4 mb-3">
            <div class="card shadow-sm">
                <div class="card-body">
                    <h5>Pending Orders</h5>
                    <p class="fs-3 fw-bold text-warning"><?= $pending_orders ?></p>
                </div>
            </div>
        </div>
    </div>
    <!-- Filters -->
    <div class="card shadow-sm mb-4">
        <div class="card-body">
            <h5 class="card-title">Filter Orders</h5>
            <form method="get" class="row g-3">
                <div class="col-md-2">
                    <label class="form-label">Branch Name</label>
                    <input type="text" name="branch_name" class="form-control" value="<?= htmlspecialchars($branch_name) ?>">
                </div>
                <div class="col-md-2">
                    <label class="form-label">Order #</label>
                    <input type="text" name="order_id" class="form-control" value="<?= htmlspecialchars($order_id) ?>">
                </div>
                <div class="col-md-2">
                    <label class="form-label">From Date</label>
                    <input type="date" name="start_date" class="form-control" value="<?= htmlspecialchars($start_date) ?>">
                </div>
                <div class="col-md-2">
                    <label class="form-label">To Date</label>
                    <input type="date" name="end_date" class="form-control" value="<?= htmlspecialchars($end_date) ?>">
                </div>
                <div class="col-md-2">
                    <label class="form-label">Status</label>
                    <select name="status" class="form-select">
                        <option value="">All</option>
                        <?php foreach ($statuses as $s): ?>
                            <option value="<?= $s ?>" <?= $status == $s ? 'selected' : '' ?>><?= ucfirst($s) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-1 d-flex align-items-end">
                    <button type="submit" class="btn btn-outline-primary w-100">Apply</button>
                </div>
            <div class="col-md-1 d-flex align-items-end">
                <a href="dashboard.php" class="btn btn-outline-secondary btn-sm">Clear</a>
<!--                <a href="dashboard.php?<?= http_build_query($_GET) ?>&export=excel" class="btn btn-outline-success btn-sm">Export to Excel</a> -->
            </div>
            </form>

        </div>
    </div>
    <!-- Orders Table -->
    <div class="card shadow-sm mb-4">
        <div class="card-body">
            <h5 class="card-title">Recent Orders</h5>
            <div class="table-responsive">
                <table class="table table-striped align-middle">
                    <thead class="table-dark">
                        <tr>
                            <th>ID</th>
                            <th>Branch</th>
                            <th>Order Date</th>
                            <th>Created at</th>
                            <th>Updated at</th>
                            <th>Status</th>
                            <th>Order Quantity</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php while ($order = $recent_orders->fetch_assoc()): ?>
                        <tr>
                            <td><?= $order['id'] ?></td>
                            <td><?= htmlspecialchars($order['branch_name']) ?></td>
                            <td><?= date('M j, Y', strtotime($order['order_date'])) ?></td>
                                        <td><?= date('M j, Y H:m:s', strtotime($order['order_date'])) ?></td>
                                <td><?= $order['updated_at'] ? date('M j, Y', strtotime($order['updated_at'])) : 'Not specified' ?></td> 
                            <td>
                                <span class="badge bg-<?php if ($order['status'] == 'cancelled') {echo 'dark';} 
                                elseif ($order['status'] == 'pending') {echo 'warning';} else {echo 'success';}?>">
                            <?= ucfirst($order['status']) ?>
                                </span>
                            </td>
                            <td><?= number_format($order['total_amount'], 0) ?></td>
                            <td><a href="orders/view.php?id=<?= $order['id'] ?>" class="btn btn-sm btn-outline-info">View</a></td>
                        </tr>
                    <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <!-- Admin Menu -->
    <div class="d-flex gap-2 flex-wrap">
        <a href="branches/index.php" class="btn btn-outline-primary">Manage Branches</a>
        <a href="products/index.php" class="btn btn-outline-primary">Manage Products</a>
        <a href="mappings/index.php" class="btn btn-outline-primary">Product Mappings</a>
        <a href="orders/index.php" class="btn btn-outline-primary">View All Orders</a>
    </div>
</div>
<?php include 'includes/footer.php'; ?>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>