<?php
require_once '../config.php';
include 'includes/auth.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $branch_id = $_SESSION['branch_id'];
    $selected_products = $_POST['products'] ?? [];
    $quantities = $_POST['quantities'] ?? [];
    $delivery_date = $_POST['delivery_date'] ?? null;
    
    if (empty($selected_products)) {
        header("Location: products.php?error=Please select at least one product");
        exit();
    }
    
    // Start transaction
    $conn->begin_transaction();
    
    try {
        $total_amount = 0;
        $total_qty = 0;
        $order_items = [];
        
        // Verify products are available to this branch and calculate total
        foreach ($selected_products as $product_id) {
            $quantity = $quantities[$product_id] ?? 1;
            
            $stmt = $conn->prepare("
                SELECT p.price FROM products p
                JOIN branch_products bp ON p.id = bp.product_id
                WHERE bp.branch_id = ? AND p.id = ? AND p.status = 'active'
            ");
            $stmt->bind_param("ii", $branch_id, $product_id);
            $stmt->execute();
            $result = $stmt->get_result();
            
            if ($result->num_rows === 1) {
                $product = $result->fetch_assoc();
                $price = $product['price'];
                $item_total = $price * $quantity;
                $total_amount += $item_total;
                $total_qty += $quantity;
                
                $order_items[] = [
                    'product_id' => $product_id,
                    'quantity' => $quantity,
                    'price' => $price
                ];
            } else {
                throw new Exception("Product not available to your branch");
            }
        }
        
        // Create order
        $stmt = $conn->prepare("
            INSERT INTO orders (branch_id, total_amount, status, delivery_date)
            VALUES (?, ?, 'pending', ?)
        ");
        $stmt->bind_param("ids", $branch_id, $total_qty, $delivery_date);
        $stmt->execute();
        $order_id = $stmt->insert_id;
        
        // Add order items
        $stmt = $conn->prepare("
            INSERT INTO order_items (order_id, product_id, quantity, price)
            VALUES (?, ?, ?, ?)
        ");
        
        foreach ($order_items as $item) {
            $stmt->bind_param("iiid", $order_id, $item['product_id'], $item['quantity'], $item['price']);
            $stmt->execute();
        }
        
        // Commit transaction
        $conn->commit();
        
        header("Location: order_confirmation.php?order_id=$order_id");
        exit();
        
    } catch (Exception $e) {
        // Rollback on error
        $conn->rollback();
        die("Error processing order: " . $e->getMessage());
    }
}
?>