<?php
function exportOrdersToExcel($orders, $filename = 'orders_export') {
    // Set headers for Excel download
    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment; filename="' . $filename . '.xls"');
    header('Cache-Control: max-age=0');
    
    // Start output buffer
    ob_start();
    
    // Create Excel file content
    echo '<table border="1">';
    
    // Header row
    echo '<tr>';
    echo '<th>ORDER #</th>';
    echo '<th>SOLD TO PARTY</th>';
    echo '<th>SOLD TO PARTY NAME</th>';
    echo '<th>SALES_ORG</th>';
    echo '<th>PLANT</th>';
    echo '<th>ORDER TYPE</th>';
    echo '<th>DATE</th>';
    echo '<th>MATERIAL</th>';
    echo '<th>MATERIAL DESCRIPTION</th>';
    echo '<th>TARGET_QTY</th>';
    echo '<th>STORE_LOC</th>';
    echo '<th>STATUS</th>';
    echo '</tr>';
    
    // Data rows
    foreach ($orders as $order) {
        echo '<tr>';
        echo '<td>' . htmlspecialchars($order['id']) . '</td>';
        echo '<td>' . htmlspecialchars($order['branch_code']) . '</td>';
        echo '<td>' . htmlspecialchars($order['branch_name']) . '</td>';
        echo '<td>1000</td>';
        echo '<td>1300</td>';
        echo '<td>ZISR</td>';
        echo '<td>' . date('d.m.Y', strtotime($order['order_date'])) . '</td>';
        echo '<td>' . htmlspecialchars($order['product_code']) . '</td>';
        echo '<td>' . htmlspecialchars($order['product_name']) . '</td>';
        echo '<td>' . htmlspecialchars($order['quantity']) . '</td>';
        echo '<td>1399</td>';
        echo '<td>' . htmlspecialchars($order['status']) . '</td>';
        echo '</tr>';
    }
    
    echo '</table>';
    
    // End output buffer and send to browser
    ob_end_flush();
    exit();
}
?>