<?php
session_start();
if (isset($_SESSION['admin_id'])) {
    header("Location: admin/dashboard.php");
    exit();
} elseif (isset($_SESSION['branch_id'])) {
    header("Location: branch/dashboard.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>B2B Ordering System</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <!-- Bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light d-flex align-items-center" style="height:100vh;">

    <div class="container text-center">
        <div class="row justify-content-center">
            <div class="col-md-6 col-lg-4">
                <div class="card shadow-lg">
                    <div class="card-header bg-primary text-white">
                        <h4 class="mb-0">B2B Ordering System</h4>
                    </div>
                    <div class="card-body">
                        <p class="text-muted">Please choose your login type:</p>
                        <div class="d-grid gap-3">
                            <a href="admin/index.php" class="btn btn-primary btn-lg">🔑 Admin Login</a>
                            <a href="manager/index.php" class="btn btn-secondary btn-lg">🔑 Manager Login</a>
                            <a href="branch/index.php" class="btn btn-success btn-lg">🏬 Branch Login</a>
                        </div>
                    </div>
                    <div class="card-footer text-muted small">
                        © <?= date('Y') ?> B2B Ordering System
                    </div>
                </div>
            </div>
        </div>
    </div>

</body>
</html>
