<?php
require_once '../config.php';
include 'includes/auth.php';
include_once '../includes/nav_helper.php';
date_default_timezone_set('Asia/Karachi');

// Check if user is admin
//$isAdmin = ($_SESSION['user_type'] === 'admin');
$isAdmin = true;
$master_customer = ($_SESSION['master_customer']);
//$_SESSION['branch_id'] = 
//$master_customer = 1;

// Get order ID from URL
$order_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if ($order_id <= 0) {
    die("Invalid order ID");
}

// Fetch order details
$order_query = "SELECT * FROM orders WHERE id = $order_id";
$order_result = $conn->query($order_query);
if ($order_result->num_rows === 0) {
    die("Order not found");
}
$order = $order_result->fetch_assoc();

// Check permissions
if (!$isAdmin) {
    $user_branch_id = $_SESSION['branch_id'];
    if ($order['branch_id'] != $user_branch_id) {
        die("You don't have permission to edit this order");
    }
}

// Get branch ID from the order
$selected_branch_id = $order['branch_id'];

// Get branch details
$branch_query = "SELECT name, code FROM branches WHERE id = $selected_branch_id";
$branch_result = $conn->query($branch_query);
$branch = $branch_result->fetch_assoc();

// Get products assigned to the selected branch
$stmt = $conn->prepare("
    SELECT p.* FROM products p
    JOIN branch_products bp ON p.id = bp.product_id
    WHERE bp.branch_id = ? AND p.status = 'active'
");
$stmt->bind_param("i", $selected_branch_id);
$stmt->execute();
$products = $stmt->get_result();

// Get existing order items
$order_items_query = "SELECT product_id, quantity FROM order_items WHERE order_id = $order_id";
$order_items_result = $conn->query($order_items_query);
$order_items = [];
while ($item = $order_items_result->fetch_assoc()) {
    $order_items[$item['product_id']] = $item['quantity'];
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get the delivery date
    $delivery_date = $_POST['delivery_date'];
    $total_amount = 0;
    
    // Delete existing order items
    $conn->query("DELETE FROM order_items WHERE order_id = $order_id");
    
    // Insert new order items
    if (isset($_POST['products']) && is_array($_POST['products'])) {
        $quantities = $_POST['quantities'];
        foreach ($_POST['products'] as $product_id) {
            $quantity = isset($quantities[$product_id]) ? (int)$quantities[$product_id] : 1;
            if ($quantity > 0) {
                $total_amount += $quantity;
                $insert_item = $conn->prepare("INSERT INTO order_items (order_id, product_id, quantity) VALUES (?, ?, ?)");
                $insert_item->bind_param("iii", $order_id, $product_id, $quantity);
                $insert_item->execute();
            }
        }
    }
    
    // Update the order header
    $updated_at = date('Y-m-d H:i:s');
    $update_order = $conn->prepare("UPDATE orders SET delivery_date = ?, total_amount = ?, updated_at = ? WHERE id = ?");
    $update_order->bind_param("sisi", $delivery_date, $total_amount, $updated_at, $order_id);
    $update_order->execute();
    
    // Redirect to order details
    // header("Location: orders.php");
    header("Location: orders.php?action=view&id=$order_id");
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Edit Order #<?= $order_id ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<?php include 'includes/header.php'; ?>
<div class="container py-5">
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
            <h4 class="mb-0">Edit Order #<?= $order_id ?></h4>
            <div>
                <span class="badge bg-light text-dark"><?= htmlspecialchars($branch['code'] . ' - ' . $branch['name']) ?></span>
            </div>
        </div>
        <div class="card-body">
            <form method="post">
                <div class="row mb-3">
                    <div class="col-md-4">
                        <label for="delivery_date" class="form-label">Delivery Date:</label>
                        <input type="date" class="form-control" 
                               name="delivery_date" id="delivery_date" 
                               value="<?= htmlspecialchars($order['delivery_date']) ?>" readonly>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Order Status:</label>
                        <input type="text" class="form-control" 
                               value="<?= htmlspecialchars(ucfirst($order['status'])) ?>" readonly>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Order Date:</label>
                        <input type="text" class="form-control" 
                               value="<?= date('M d, Y H:m:s', strtotime($order['order_date'])) ?>" readonly>
                    </div>
                </div>
                
                <h5 class="mb-3">Order Items</h5>
                <div class="table-responsive">
                    <table class="table table-striped table-bordered align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>Product Code</th>
                                <th>Product</th>
                                <th width="120">Quantity</th>
                                <th width="60">Include</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while ($product = $products->fetch_assoc()): ?>
                            <tr>
                                <td><?= htmlspecialchars($product['code']) ?></td>
                                <td><?= htmlspecialchars($product['name']) ?></td>
                                <td>
                                    <input type="number" class="form-control" 
                                           name="quantities[<?= $product['id'] ?>]" 
                                           value="<?= isset($order_items[$product['id']]) ? htmlspecialchars($order_items[$product['id']]) : '1' ?>" 
                                           min="1">
                                </td>
                                <td class="text-center">
                                    <input type="checkbox" class="form-check-input" 
                                           name="products[]" value="<?= $product['id'] ?>"
                                           <?= isset($order_items[$product['id']]) ? 'checked' : '' ?>>
                                </td>    
                            </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
                
                <div class="d-flex gap-3 mt-4">
                    <button type="submit" class="btn btn-success">💾 Update Order</button>
                    <a href="orders.php" class="btn btn-secondary">⬅ Cancel</a>
                </div>
            </form>
        </div>
    </div>
</div>
<?php include 'includes/footer.php'; ?>
</body>
</html>