<?php
require_once '../config.php';
include 'includes/auth.php';
include_once '../includes/nav_helper.php';

$master_customer = $_SESSION['master_customer'];

// Initialize filter variables
$branch_name= $_GET['branch_name'] ?? '';
$order_id = $_GET['order_id'] ?? '';
$start_date = $_GET['start_date'] ?? '';
$end_date = $_GET['end_date'] ?? '';
$status = $_GET['status'] ?? '';


// Build query
$query = "SELECT o.*, b.name FROM orders o JOIN branches b ON b.id = o.branch_id JOIN customers c ON b.master_customer = c.id WHERE master_customer = ?";
$params = [$master_customer];
$types = 'i';


if (!empty($branch_name)) {
    $query .= " AND b.name like ?";
    $params[] = "%$branch_name%";
    $types .= 's';
}
if (!empty($order_id)) {
    $query .= " AND o.id = ?";
    $params[] = $order_id;
    $types .= 'i';
}
if (!empty($start_date)) {
    $query .= " AND order_date >= ?";
    $params[] = $start_date;
    $types .= 's';
}
if (!empty($end_date)) {
    $query .= " AND order_date <= ?";
    $params[] = $end_date . ' 23:59:59';
    $types .= 's';
}
if (!empty($status)) {
    $query .= " AND o.status = ?";
    $params[] = $status;
    $types .= 's';
}

$query .= " ORDER BY order_date DESC";
$stmt = $conn->prepare($query);
$stmt->bind_param($types, ...$params);
$stmt->execute();
$orders = $stmt->get_result();
$rowcount = mysqli_num_rows($orders);

$statuses = ['pending','processed','cancelled'];

// View details
if (isset($_GET['action'], $_GET['id']) && $_GET['action'] == 'view') {
    $order_id = $_GET['id'];
    $stmt = $conn->prepare("SELECT o.*, b.name FROM orders o JOIN branches b ON b.id = o.branch_id WHERE o.id = ?");
    $stmt->bind_param("i", $order_id);
    $stmt->execute();
    $order_result = $stmt->get_result();

    if ($order_result->num_rows === 1) {
        $order = $order_result->fetch_assoc();

        $stmt = $conn->prepare("
            SELECT oi.*, p.code AS product_code, p.name AS product_name 
            FROM order_items oi 
            JOIN products p ON oi.product_id = p.id 
            WHERE oi.order_id = ?
        ");
        $stmt->bind_param("i", $order_id);
        $stmt->execute();
        $items = $stmt->get_result();
        ?>
        <!DOCTYPE html>
        <html lang="en">
        <head>
            <meta charset="UTF-8">
            <title>Order Details</title>
            <link rel="stylesheet" href="../assets/css/style.css">
            <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
        </head>
        <body class="bg-light">
        <?php include 'includes/header.php'; ?>
        <div class="container py-5">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white">
                    <h4 class="mb-0">Order # <?= $order_id ?>  (<?= $order['name'] ?>)</h4>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-md-4"><strong>Order Date:</strong> <?= date('F j, Y', strtotime($order['order_date'])) ?></div>
                        <div class="col-md-4"><strong>Order Time:</strong> <?= date('F j, Y H:m:s', strtotime($order['order_date'])) ?></div>
                           <div class="col-md-4"><strong>Order Updated at:</strong> <?= $order['updated_at'] ? date('F j, Y H:m:s', strtotime($order['updated_at'])) : 'Not specified' ?></div>
                                <div class="col-md-4"><strong>Status:</strong>
                            
                            <span class="badge bg-<?php if ($order['status'] == 'cancelled') {echo 'dark';} 
                                elseif ($order['status'] == 'pending') {echo 'warning';} else {echo 'success';}?>">
                                <?= ucfirst($order['status']) ?>
                                </span>

                            </div>
                        <div class="col-md-6"><strong>Order Quantity:</strong> <?= number_format($order['total_amount'], 2) ?></div>
                    </div>

                    <h5>Order Items</h5>
                    <div class="table-responsive">
                        <table class="table table-striped table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>Product Code</th>
                                    <th>Product</th>
                                    <th>Quantity</th>
                                    <!-- <th>Price</th> -->
                                    <!-- <th>Total</th> -->
                                </tr>
                            </thead>
                            <tbody>
                            <?php while ($item = $items->fetch_assoc()): ?>
                                <tr>
                                    <td><?= htmlspecialchars($item['product_code']) ?></td>
                                    <td><?= htmlspecialchars($item['product_name']) ?></td>
                                    <td><?= $item['quantity'] ?></td>
                                    <!-- <td>$<?= number_format($item['price'], 2) ?></td> -->
                                    <!-- <td>$<?= number_format($item['quantity'] * $item['price'], 2) ?></td> -->
                                </tr>
                            <?php endwhile; ?>
                            </tbody>
                        </table>
                    </div>

                    <!-- <a href="orders.php<?= !empty($_GET) ? '?' . http_build_query($_GET) : '' ?>" class="btn btn-secondary">⬅ Back to Orders</a> -->
                    <a href="orders.php" class="btn btn-secondary">⬅ Back to Orders</a>
                </div>
            </div>
        </div>
        <?php include 'includes/footer.php'; ?>
        </body>
        </html>
        <?php exit();
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Order History</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body class="bg-light">
<?php include 'includes/header.php'; ?>
<div class="container py-5">
    <div class="card shadow-sm mb-4">
        <div class="card-header bg-primary text-white">
            <h4 class="mb-0">Order History <span class="badge bg-dark"><?= $rowcount ?></span></h4>
        </div>
        <div class="card-body">
            <form method="get" class="row g-3">
                <div class="col-md-2">
                    <label for="order_id" class="form-label">Branch Name</label>
                    <input type="text" id="branch_name" name="branch_name" value="<?= htmlspecialchars($branch_name) ?>" class="form-control">
                </div>
                <div class="col-md-2">
                    <label for="order_id" class="form-label">Order #</label>
                    <input type="text" id="order_id" name="order_id" value="<?= htmlspecialchars($order_id) ?>" class="form-control">
                </div>
                <div class="col-md-2">
                    <label for="start_date" class="form-label">From Date</label>
                    <input type="date" id="start_date" name="start_date" value="<?= htmlspecialchars($start_date) ?>" class="form-control">
                </div>
                <div class="col-md-2">
                    <label for="end_date" class="form-label">To Date</label>
                    <input type="date" id="end_date" name="end_date" value="<?= htmlspecialchars($end_date) ?>" class="form-control">
                </div>
                <div class="col-md-2">
                    <label for="status" class="form-label">Status</label>
                    <select id="status" name="status" class="form-select">
                        <option value="">All</option>
                        <?php foreach ($statuses as $s): ?>
                            <option value="<?= $s ?>" <?= $status == $s ? 'selected' : '' ?>><?= ucfirst($s) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-2 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary me-2">Apply</button>
                    <a href="orders.php" class="btn btn-outline-secondary">Clear</a>
                </div>
            </form>
        </div>
    </div>

    <div class="card shadow-sm">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-striped table-hover">
                    <thead class="table-light">
                        <tr>
                            <th>ID</th>
                            <th>Branch Name</th>
                            <th>Order Date</th>
                            <th>Order Time</th>
                            <th>Status</th>
                            <th>Total Quantity</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php while ($order = $orders->fetch_assoc()): ?>
                        <tr>
                            <td><?= $order['id'] ?></td>
                            <td><?= $order['name'] ?></td>
                            <td><?= date('M j, Y', strtotime($order['order_date'])) ?></td>
                            <td><?= date('M j, Y H:m:s', strtotime($order['order_date'])) ?></td>
                             <td>
                             <span class="badge bg-<?php if ($order['status'] == 'cancelled') {echo 'dark';} 
                                elseif ($order['status'] == 'pending') {echo 'warning';} else {echo 'success';}?>">
                            <?= ucfirst($order['status']) ?>
                                </span>
                            </td>

                            </td>
                            <!-- <td><?= ucfirst($order['status']) ?></td> -->
                            <td><?= number_format($order['total_amount']) ?></td>
                           <td><a href="?action=view&id=<?= $order['id'] ?><?= !empty($_GET) ? '&' . http_build_query($_GET) : '' ?>" class="btn btn-sm btn-info">View</a>
                           <?php if ($order['status'] === 'pending'): ?>
                    <a href="edit_order.php?id=<?= $order['id'] ?><?= !empty($_GET) ? '&' . http_build_query($_GET) : '' ?>" class="btn btn-sm btn-info">Edit</a>
                <?php endif; ?>
                           </td>

                        </tr>
                    <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php include 'includes/footer.php'; ?>
</body>
</html>
