<?php
require_once '../config.php';
include 'includes/auth.php';
include_once '../includes/nav_helper.php';

// Check if user is admin
//$isAdmin = ($_SESSION['user_type'] === 'admin');
$isAdmin = true;
$master_customer = ($_SESSION['master_customer']);
//$_SESSION['branch_id'] = 
//$master_customer = 1;

// Get branch ID from session or selection
if ($isAdmin) {
    $selected_branch_id = isset($_GET['branch_id']) ? (int)$_GET['branch_id'] : null;
    
    // Get all branches for dropdown

        $branches = $conn->query("SELECT id, name, code FROM branches WHERE master_customer = $master_customer AND status = 'active' ORDER BY code");

} else {
    $branch_id = $_SESSION['branch_id'];
    $selected_branch_id = $branch_id;
}

// Get products assigned to the selected branch
if ($selected_branch_id) {
    $stmt = $conn->prepare("
        SELECT p.* FROM products p
        JOIN branch_products bp ON p.id = bp.product_id
        WHERE bp.branch_id = ? AND p.status = 'active'
    ");
    $stmt->bind_param("i", $selected_branch_id);
    $stmt->execute();
    $products = $stmt->get_result();
} else {
    $products = null;
}

// Current date for delivery
$current_date = date('Y-m-d');
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Available Products</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<?php    print_r($selected_branch_id); ?>
<?php $_SESSION['selected_branch_id'] = $selected_branch_id; ?>
<?php include 'includes/header.php'; ?>
<div class="container py-5">
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
            <h4 class="mb-0">Available Products</h4>
            <?php if ($isAdmin): ?>
                <div class="d-flex align-items-center">
                    <label for="branch_select" class="text-white me-2 mb-0">Select Branch:</label>
                    <select id="branch_select" class="form-select form-select-sm" style="width: auto;">
                        <option value="">-- Choose Branch --</option>
                        <?php 
                        // Reset the result pointer to fetch branches again
                        if ($isAdmin) {
                            $branches->data_seek(0);
                            while ($branch = $branches->fetch_assoc()): 
                        ?>
                            <option value="<?= $branch['id'] ?>" <?= $selected_branch_id == $branch['id'] ? 'selected' : '' ?>>
                                <?= htmlspecialchars($branch['code'] . ' - ' . $branch['name']) ?>
                            </option>
                        <?php 
                            endwhile;
                        }
                        ?>
                    </select>
                </div>
            <?php endif; ?>
        </div>
        <div class="card-body">
            <?php if (!$selected_branch_id && $isAdmin): ?>
                <div class="alert alert-info">
                    Please select a branch to view available products.
                </div>
            <?php elseif ($products && $products->num_rows > 0): ?>
                <form method="post" action="place_order.php">
                    <input type="hidden" name="branch_id" value="<?= $selected_branch_id ?>">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered align-middle">
                            <thead class="table-light">
                                <tr>
                                    <th>Product Code</th>
                                    <th>Product</th>
                                    <th width="120">Quantity</th>
                                    <th width="60">Select</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php while ($product = $products->fetch_assoc()): ?>
                                <tr>
                                    <td><?= htmlspecialchars($product['code']) ?></td>
                                    <td><?= htmlspecialchars($product['name']) ?></td>
                                    <td>
                                        <input type="number" class="form-control" 
                                               name="quantities[<?= $product['id'] ?>]" value="1" min="1">
                                    </td>
                                    <td class="text-center">
                                        <input type="checkbox" class="form-check-input" 
                                               name="products[]" value="<?= $product['id'] ?>">
                                    </td>    
                                </tr>
                                <?php endwhile; ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-2">
                            <label for="delivery_date" class="form-label">Order Date:</label>
                            <input type="date" class="form-control" 
                                   name="delivery_date" id="delivery_date" 
                                   value="<?= $current_date ?>" required readonly>
                        </div>
                    </div>
                    <div class="d-flex gap-3">
                        <button type="submit" class="btn btn-success">🛒 Place Order</button>
                        <a href="index.php" class="btn btn-secondary">⬅ Cancel</a>
                    </div>
                </form>
            <?php else: ?>
                <div class="alert alert-warning">
                    No products available for this branch.
                </div>
                <div class="d-flex gap-3">
                    <a href="index.php" class="btn btn-secondary">⬅ Cancel</a>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php include 'includes/footer.php'; ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const branchSelect = document.getElementById('branch_select');
    if (branchSelect) {
        branchSelect.addEventListener('change', function() {
            const branchId = this.value;
            if (branchId) {
                // Use current URL path to ensure correct location
                const currentPath = window.location.pathname;
                window.location.href = currentPath + '?branch_id=' + branchId;
            } else {
                // Reload without parameters
                window.location.href = window.location.pathname;
            }
        });
    }
});
</script>
</body>
</html>